---
generated_at: 2026-01-20 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-Static Classes Demo

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠が確認できたため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）

- E-01: `Examples/Misc/StaticClasses/Form1.frm` 行4: Caption = "Some Available Functions"
- E-02: `Examples/Misc/StaticClasses/Form1.frm` 行3: BorderStyle = 1 'Fixed Single
- E-03: `Examples/Misc/StaticClasses/Form1.frm` 行10-11: MaxButton = False, MinButton = False
- E-04: `Examples/Misc/StaticClasses/Form1.frm` 行15-124: Frame4 "TimeZone"定義
- E-05: `Examples/Misc/StaticClasses/Form1.frm` 行125-234: Frame3 "MathExt"定義
- E-06: `Examples/Misc/StaticClasses/Form1.frm` 行235-339: Frame2 "Environment"定義
- E-07: `Examples/Misc/StaticClasses/Form1.frm` 行340-460: Frame1 "Path"定義
- E-08: `Examples/Misc/StaticClasses/Form1.frm` 行469-480: DemonstratePath メソッド
- E-09: `Examples/Misc/StaticClasses/Form1.frm` 行482-489: DemonstrateEnvironment メソッド
- E-10: `Examples/Misc/StaticClasses/Form1.frm` 行491-503: DemonstrateMathExt メソッド
- E-11: `Examples/Misc/StaticClasses/Form1.frm` 行505-514: DemonstrateTimeZone メソッド
- E-12: `Examples/Misc/StaticClasses/Form1.frm` 行516-521: Form_Load メソッド
- E-13: `docs/code-to-docs/画面一覧/画面一覧.csv` 行3: 画面情報定義
- E-14: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行45-49: 機能マッピング情報
- E-15: `Examples/Misc/StaticClasses/Form1.frm` 全テキストボックス: Locked = True

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは"Some Available Functions" | E-01 | ○ |
| C-02 | BorderStyle = Fixed Single でサイズ変更不可 | E-02 | ○ |
| C-03 | 最大化・最小化ボタン無効 | E-03 | ○ |
| C-04 | TimeZoneフレームが存在 | E-04 | ○ |
| C-05 | MathExtフレームが存在 | E-05 | ○ |
| C-06 | Environmentフレームが存在 | E-06 | ○ |
| C-07 | Pathフレームが存在 | E-07 | ○ |
| C-08 | DemonstratePathでPath静的クラスをデモ | E-08 | ○ |
| C-09 | DemonstrateEnvironmentでEnvironment静的クラスをデモ | E-09 | ○ |
| C-10 | DemonstrateMathExtで数学関数をデモ | E-10 | ○ |
| C-11 | DemonstrateTimeZoneでTimeZone静的クラスをデモ | E-11 | ○ |
| C-12 | Form_Loadで4つのデモメソッドを呼び出し | E-12 | ○ |
| C-13 | 画面はサンプル/その他カテゴリ | E-13 | ○ |
| C-14 | Path, Environment, CorMath, TimeZone機能に関連 | E-14 | ○ |
| C-15 | 全テキストボックスは読み取り専用 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目はありません
- VBCorLib.dllの参照設定はプロジェクトファイル(.vbp)で確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] 全ての主張にソースコード根拠が対応している
- [ ] Environment.WorkingSetがNT系以外で動作するか確認（コメントに「NT Only」あり）
- [ ] タイムゾーン情報が正しく取得できる環境か確認
